export const getVideo = (url: string) => {
  return url?.startsWith("/")
    ? `${process.env.NEXT_PUBLIC_API_URL}${url}`
    : `${process.env.NEXT_PUBLIC_API_URL}/${url}`;
};

export const getYouTubeEmbedUrl = (url: string) => {
  const videoIdMatch = url.match(
    /(?:youtu\.be\/|youtube\.com\/(?:watch\?v=|embed\/))([\w-]+)/
  );
  return videoIdMatch ? `https://www.youtube.com/embed/${videoIdMatch[1]}` : "";
};
