/**
 * Utility function to slugify a string.
 * Converts a string into a URL-friendly format.
 * Removes diacritics, emojis, and special characters,
 * and replaces spaces with hyphens.
 */
const slugify = (text) => {
  if (!text || typeof text !== "string") {
    return "";
  }
  return text
    .toString()
    .normalize("NFD") // Normalize accented letters
    .replace(/[\u0300-\u036f]/g, "") // Remove diacritics
    .replace(/[\u{1F600}-\u{1F64F}]/gu, "") // Remove emojis
    .toLowerCase()
    .trim()
    .replace(/[_\s]+/g, "-") // Replace spaces and underscores with hyphen
    .replace(/[^\w\-]+/g, "") // Remove all non-word characters except hyphen
    .replace(/\-\-+/g, "-") // Collapse multiple hyphens
    .replace(/^-+|-+$/g, ""); // Trim hyphens from start and end
};

module.exports = { slugify };
