export const dynamic = "force-dynamic";
import React from "react";
import fetchContentType from "@/lib/strapi/fetchContentType";

export default async function NotFound() {
  const pageData = await fetchContentType("global", ``, true);

  if (pageData?.not_found) {
    return (
      <div className="flex flex-col items-center justify-center h-screen w-full">
        const Component = await safeImport(
        toKebabCase(pageData.not_found.cmp_variant) );
      </div>
    );
  }

  return (
    <div className="flex flex-col items-center justify-center h-screen w-full">
      <div className="text-center">
        <h1 className="text-4xl font-bold mb-4">404</h1>
        <p className="text-lg">Page not found</p>
      </div>
    </div>
  );
}
