import { safeImport } from "@/utils/safeImport";
import { toKebabCase } from "@/utils/toKebabCase";
import React from "react";

interface DynamicZoneComponent {
  __component: string;
  id: number;
  [key: string]: any;
}

interface Props {
  dynamicZone: DynamicZoneComponent[];
  locale: string;
}

const DynamicZoneManager: React.FC<Props> = ({ dynamicZone, locale }) => {
  return (
    <div>
      {dynamicZone.map(async (componentData) => {
        const Component = await safeImport(
          toKebabCase(componentData.cmp_variant)
        );

        if (!Component) {
          console.warn(
            `No component found for: ${toKebabCase(componentData.cmp_variant)}`
          );
          return null;
        }

        return (
          <Component
            key={componentData.id}
            {...componentData}
            locale={locale}
          />
        );
      })}
    </div>
  );
};

export default DynamicZoneManager;
