import { componentRegistry } from "./registry";

export const componentCategoryMapper = Object.keys(componentRegistry).reduce(
  (acc, key) => {
    const [category, component] = key.split("/");
    acc[component] = `${category}/${component}`;
    return acc;
  },
  {} as Record<string, string>
);

console.log(componentCategoryMapper["hero1"]);
