export interface NavigationItem {
  documentId: string;
  title: string;
  type: "WRAPPER" | "EXTERNAL";
  path: string;
  externalPath: string | null;
  uiRouterKey: string;
  menuAttached: boolean;
  order: number;
  collapsed: boolean;
  additionalFields: Record<string, unknown>;
  audience: string[];
  autoSync: boolean;
  parent: Omit<NavigationItem, "parent" | "items"> | null;
  items: NavigationItem[] | null;
}

/* -------------------------------
   Build Tree Helper
-------------------------------- */
export function buildNavigationTree(items: NavigationItem[]): NavigationItem[] {
  const map = new Map<string, NavigationItem>();
  items?.forEach((item) => map.set(item.documentId, { ...item, items: [] }));

  const roots: NavigationItem[] = [];
  map.forEach((item) => {
    if (item.parent && map.has(item.parent.documentId)) {
      map.get(item.parent.documentId)!.items!.push(item);
    } else {
      roots.push(item);
    }
  });

  const sortItems = (arr: NavigationItem[]) => {
    arr.sort((a, b) => a.order - b.order);
    arr.forEach((i) => i.items && sortItems(i.items));
  };
  sortItems(roots);
  return roots;
}
