import { componentCategoryMapper } from "@/r/componentMapper";
import { componentRegistry } from "@/r/registry";

export async function safeImport(path: string) {
  try {
    const mod = await componentRegistry[componentCategoryMapper[path]]();

    return mod.default || null;
  } catch (err) {
    console.warn(`[LocaleLayout] Component not found: ${path}`);
    return null;
  }
}
