
export interface DynamicZoneAbout {
  id?: number;
  cmp_variant: string;
  title?: string;
  subtitle?: string;
  description?: string;
  content?: any;
  buttons?: SharedButton[] | null;
  image?: Media | null;
};

export interface DynamicZoneCard {
  id?: number;
  cmp_variant: string;
  title?: string;
  subtitle?: string;
  description?: string;
  cards?: ItemsCardItem[] | null;
};

export interface DynamicZoneCta {
  id?: number;
  cmp_variant: string;
  title?: string;
  subtitle?: string;
  description?: string;
  buttons?: SharedButton[] | null;
};

export interface DynamicZoneFaq {
  id?: number;
  cmp_variant: string;
  title?: string;
  subtitle?: string;
  description?: string;
  coverImage?: Media | null;
  items?: ItemsFaqItem[] | null;
};

export interface DynamicZoneHero {
  id?: number;
  cmp_variant: string;
  title?: string;
  subtitle?: string;
  description?: string;
  primary_buttons?: SharedButton[] | null;
  hero_image?: Media | null;
  badge?: string;
};

export interface DynamicZoneTestimonial {
  id?: number;
  cmp_variant: string;
  title?: string;
  subtitle?: string;
  description?: string;
  items?: ItemsTestimonialItem[] | null;
};

export interface GlobalFooter {
  id?: number;
  cmp_variant: string;
  title?: string;
  subtitle?: string;
  tagline?: string;
  lightLogo?: Media | null;
  darkLogo?: Media | null;
  copyright?: string;
};

export interface GlobalHeader {
  id?: number;
  cmp_variant: string;
  title?: string;
  subtitle?: string;
  tagline?: string;
  lightLogo?: Media | null;
  darkLogo?: Media | null;
};

export interface GlobalNotFound {
  id?: number;
  cmp_variant: string;
  title?: string;
  subtitle?: string;
  description?: string;
  image?: Media | null;
  buttons?: SharedButton[] | null;
};

export interface ItemsCardItem {
  id?: number;
  slug: string;
  isFeatured?: boolean;
  title: string;
  image: Media | null;
  date: Date | string;
};

export interface ItemsFaqItem {
  id?: number;
  question?: string;
  answer?: string;
  isOpen?: boolean;
};

export interface ItemsTestimonialItem {
  id?: number;
  name?: string;
  designation?: string;
  message: string;
  image?: Media | null;
  rating?: number;
  date?: Date | string;
  company?: string;
  location?: string;
};

export interface SharedButton {
  id?: number;
  label?: string;
  path?: string;
  target?: "_self" | "_blank" | "_parent" | "_top";
  variant?: "default" | "secondary" | "outline" | "ghost" | "link" | "destructive";
  size?: "default" | "sm" | "lg" | "icon";
  icon?: Media | null;
};

export interface SharedLogo {
  id?: number;
  lightLogo?: Media | null;
  darkLogo?: Media | null;
  type?: "primary" | "secondary" | "tertiary";
};

export interface SharedMedia {
  id?: number;
  file?: Media | null;
};

export interface SharedQuote {
  id?: number;
  title?: string;
  body?: string;
};

export interface SharedRichText {
  id?: number;
  body?: string;
};

export interface SharedSecondaryLogo {
  id?: number;
  lightLogo?: Media | null;
  darkLogo?: Media | null;
  title?: string;
  subtitle?: string;
  tagline?: string;
};

export interface SharedSeo {
  id?: number;
  metaTitle?: string;
  metaDescription?: string;
  metaImage?: Media | null;
  keywords?: string;
  metaRobots?: string;
  structuredData?: Record<string, any>;
  metaViewport?: string;
  canonicalURL?: string;
};

export interface SharedSlider {
  id?: number;
  files?: Media[] | null;
};

export interface SharedSocialLink {
  id?: number;
  label?: string;
  url: string;
  icon?: Media | null;
  type?: "primary" | "secondary" | "tertiary";
};

export interface Global {
  id?: number;
  documentId?: string;
  createdAt?: Date | string;
  updatedAt?: Date | string;
  publishedAt?: Date | string;
  locale?: string | null;
  seo?: SharedSeo | null;
  siteName?: string;
  siteDescription?: string;
  tagline?: string;
  favicon?: Media | null;
  logos?: SharedLogo[] | null;
  header?: GlobalHeader | null;
  footer?: GlobalFooter | null;
  not_found?: GlobalNotFound | null;
  socials?: SharedSocialLink[] | null;
};

export interface Page {
  id?: number;
  documentId?: string;
  createdAt?: Date | string;
  updatedAt?: Date | string;
  publishedAt?: Date | string;
  locale?: string | null;
  seo?: SharedSeo | null;
  slug: string;
  dynamic_zone?: any;
};

export interface Media {
  id: number;
  name: string;
  alternativeText: string;
  caption: string;
  width: number;
  height: number;
  formats: { thumbnail: MediaFormat; small: MediaFormat; medium: MediaFormat; large: MediaFormat; };
  hash: string;
  ext: string;
  mime: string;
  size: number;
  url: string;
  previewUrl: string;
  provider: string;
  createdAt: Date;
  updatedAt: Date;
}

export interface MediaFormat {
  name: string;
  hash: string;
  ext: string;
  mime: string;
  width: number;
  height: number;
  size: number;
  path: string;
  url: string;
}

export interface User {
  id?: number;
  username: string;
  email: string;
  provider?: string;
  confirmed?: boolean;
  blocked?: boolean;
  createdAt?: Date | string;
  updatedAt?: Date | string;
  role: Role | null | number;
};

export interface Role {
  id?: number;
  documentId?: string;
  createdAt?: Date | string;
  updatedAt?: Date | string;
  name: string;
  description: string;
  type: string;
};

export interface FindOne<T> {
  data: T;
  meta: {
    pagination?: {
      page: number;
      pageSize: number;
      pageCount: number;
      total: number;
    }
  };
};

export interface FindMany<T> {
  data: T[];
  meta: {
    pagination?: {
      page: number;
      pageSize: number;
      pageCount: number;
      total: number;
    }
  };
};
