async function handleAudienceEntry(app, entries) {
  try {
    const UID = `plugin::navigation.audience`;

    for (const entry of entries) {
      if (!entry.name || !entry.key) continue;

      const [existing] = await app.query(UID).findMany({
        where: { key: entry.key },
      });

      if (existing) {
        await app.documents(UID).update({
          documentId: existing.id,
          data: {
            name: entry.name,
            key: entry.key,
            publishedAt: new Date(),
          },
        });
      } else {
        await app.documents(UID).create({
          data: {
            name: entry.name,
            key: entry.key,
            publishedAt: new Date(),
          },
        });
      }
    }
  } catch (error) {
    app.log.error(`Creating ${model} entry:`, error);
    throw error;
  }
}

module.exports = { handleAudienceEntry };
