"use strict";

const setPublicPermissions = async (app) => {
  try {
    const publicRole = await app
      .query("plugin::users-permissions.role")
      .findOne({
        where: {
          type: "public",
        },
      });

    const contentTypes = Object.keys(app.contentTypes).filter((uid) =>
      uid.startsWith("api::")
    );

    for (const uid of contentTypes) {
      const apiName = uid.split("::")[1];

      const permissionsData = [
        `api::${apiName}.find`,
        `api::${apiName}.findOne`,
        `plugin::i18n.locales.listLocales`,
        `plugin::upload.content-api.find`,
        `plugin::upload.content-api.findOne`,
        `plugin::navigation.client.render`,
        `plugin::navigation.client.renderChild`,
        `plugin::navigation.client.readAll`,
      ];

      for (const permission of permissionsData) {
        const existingPermission = await app
          .query("plugin::users-permissions.permission")
          .findOne({
            where: { action: permission, role: publicRole.id },
          });

        if (!existingPermission) {
          await app.query("plugin::users-permissions.permission").create({
            data: {
              action: permission,
              role: publicRole.id,
            },
          });
        }
      }
    }
  } catch (error) {
    app.log.error("Error setting public role permissions:", error);
  }
};

const setNavigationPluginConfiguration = async (app) => {
  const pluginStore = app.store({
    environment: "",
    type: "plugin",
    name: "navigation",
  });

  const existing = (await pluginStore.get({ key: "config" })) || {};

  const enforced = {
    additionalFields: ["audience"],
    allowedLevels: 5,
  };

  const nextConfig = {
    ...(typeof existing === "object" && existing !== null ? existing : {}),
    ...enforced,
  };

  await pluginStore.set({
    key: "config",
    value: nextConfig,
  });
};

module.exports = { setPublicPermissions, setNavigationPluginConfiguration };
