const xsite = require("../../xsite.json");
const axios = require("axios");
const fs = require("fs-extra");

const DATA_DIR = "./data";
const DATA_FILE = "./data/data.json";

const fetcher = async (url, options = {}) => {
  const response = await axios({ url, ...options });
  return response.data;
};

const fetchAndSaveProjectJSONDataTOFile = async (app) => {
  try {
    if (!fs.existsSync(DATA_DIR)) {
      fs.mkdirSync(DATA_DIR, { recursive: true });
    }

    const res = await fetcher(
      `${xsite.url}/project/${xsite.projectId}/get-json`,
      {
        method: "GET",
        headers: {
          "xsite-api-key": xsite["xsite-api-key"],
          "xsite-api-secret": xsite["xsite-api-secret"],
        },
      }
    );

    // let mapperJSON;
    // try {
    //   mapperJSON = await fetcher(
    //     `${xsite["xsite-strapi-builder-url"]}/mapper.json`
    //   );
    // } catch (error) {
    //   throw error;
    // }

    // let data;
    // try {
    //   data = mapDynamicZoneComponents(res, mapperJSON);
    // } catch (error) {
    //   app.log.error("Error mapping dynamic zone components:", error);
    // }

    await fs.outputFile(DATA_FILE, JSON.stringify(res, null, 2));
  } catch (error) {
    app.log.error("Error fetching or saving project JSON data:", error);
  }
};

const randomUIDSlugGenerator = (entry, schema) => {
  const slugField = Object.keys(schema.attributes || {}).find(
    (key) => schema.attributes[key].type === "uid"
  );

  if (!slugField) {
    return entry;
  }

  entry[slugField] = crypto.randomUUID();
  return entry;
};

const autoGenerateSlug = (entry, schema) => {
  const slugField = Object.keys(schema.attributes || {}).find(
    (key) => schema.attributes[key].type === "uid"
  );

  if (!slugField) {
    return entry;
  }

  const slugConfig = schema.attributes[slugField];
  const targetField = slugConfig.targetField;

  if (entry[slugField]) {
    return entry;
  }

  if (!targetField || !entry[targetField]) {
    return entry;
  }

  entry[slugField] = slugify(entry[targetField]);
  return entry;
};

const getCleanVariableNameWithUnderscore = (name) => {
  return name.replace(/[^a-zA-Z0-9_$]/g, "_");
};

const validateXSiteConfig = () => {
  const requiredKeys = [
    "xsite-api-key",
    "xsite-api-secret",
    "url",
    "organizationId",
    "projectId",
    "xsite-strapi-builder-url",
  ];

  const missingConfigs = [];

  for (const key of requiredKeys) {
    switch (key) {
      case "xsite-api-key":
      case "xsite-api-secret":
      case "xsite-strapi-builder-url":
        if (!xsite[key]) missingConfigs.push(key);
        break;
      case "url":
      case "organizationId":
      case "projectId":
        if (!xsite[key]) missingConfigs.push(key);
        break;
      default:
        break;
    }
  }
  if (missingConfigs.length > 0) {
    throw new Error(
      `[ERROR] Missing xsite configuration: ${missingConfigs.join(
        ", "
      )}. Please check your xsite.json file.`
    );
  }
};

const slugify = (text) => {
  if (!text || typeof text !== "string") {
    return "";
  }
  return text
    .toString()
    .normalize("NFD")
    .replace(/[\u0300-\u036f]/g, "")
    .replace(/[\u{1F600}-\u{1F64F}]/gu, "")
    .toLowerCase()
    .trim()
    .replace(/[_\s]+/g, "-")
    .replace(/[^\w\-]+/g, "")
    .replace(/\-\-+/g, "-")
    .replace(/^-+|-+$/g, "");
};

module.exports = {
  randomUIDSlugGenerator,
  autoGenerateSlug,
  getCleanVariableNameWithUnderscore,
  validateXSiteConfig,
  slugify,
  fetchAndSaveProjectJSONDataTOFile,
  fetcher,
};
