import type { Schema, Struct } from '@strapi/strapi';

export interface DynamicZoneAbout extends Struct.ComponentSchema {
  collectionName: 'components_dynamic_zone_about_uss';
  info: {
    description: '';
    displayName: 'About Us';
    icon: 'info';
  };
  attributes: {
    buttons: Schema.Attribute.Component<'shared.button', true>;
    cmp_variant: Schema.Attribute.String & Schema.Attribute.Required;
    content: Schema.Attribute.Blocks;
    description: Schema.Attribute.Text;
    image: Schema.Attribute.Media<'images'>;
    subtitle: Schema.Attribute.String;
    title: Schema.Attribute.String;
  };
}

export interface DynamicZoneCard extends Struct.ComponentSchema {
  collectionName: 'components_dynamic_zone_cards';
  info: {
    description: '';
    displayName: 'Card';
    icon: 'address-card';
  };
  attributes: {
    cards: Schema.Attribute.Component<'items.card-item', true>;
    cmp_variant: Schema.Attribute.String & Schema.Attribute.Required;
    description: Schema.Attribute.Text;
    subtitle: Schema.Attribute.Text;
    title: Schema.Attribute.String;
  };
}

export interface DynamicZoneCta extends Struct.ComponentSchema {
  collectionName: 'components_common_ctas';
  info: {
    description: 'Reusable call-to-action component';
    displayName: 'CTA';
    icon: 'cursor-click';
  };
  attributes: {
    buttons: Schema.Attribute.Component<'shared.button', true>;
    cmp_variant: Schema.Attribute.String & Schema.Attribute.Required;
    description: Schema.Attribute.Text;
    subtitle: Schema.Attribute.Text;
    title: Schema.Attribute.String;
  };
}

export interface DynamicZoneFaq extends Struct.ComponentSchema {
  collectionName: 'components_dynamic_zone_faqs';
  info: {
    description: '';
    displayName: 'Frequently Asked Questions';
    icon: 'question-circle';
  };
  attributes: {
    cmp_variant: Schema.Attribute.String & Schema.Attribute.Required;
    coverImage: Schema.Attribute.Media;
    description: Schema.Attribute.String;
    items: Schema.Attribute.Component<'items.faq-item', true>;
    subtitle: Schema.Attribute.String;
    title: Schema.Attribute.String;
  };
}

export interface DynamicZoneHero extends Struct.ComponentSchema {
  collectionName: 'components_dynamic_zone_heros';
  info: {
    description: '';
    displayName: 'Hero';
    icon: 'layout';
  };
  attributes: {
    badge: Schema.Attribute.String;
    cmp_variant: Schema.Attribute.String & Schema.Attribute.Required;
    description: Schema.Attribute.String;
    hero_image: Schema.Attribute.Media<'images'>;
    primary_buttons: Schema.Attribute.Component<'shared.button', true>;
    subtitle: Schema.Attribute.String;
    title: Schema.Attribute.String;
  };
}

export interface DynamicZoneTestimonial extends Struct.ComponentSchema {
  collectionName: 'components_dynamic_zone_testimonials';
  info: {
    description: '';
    displayName: 'Testimonials';
    icon: 'emotionHappy';
  };
  attributes: {
    cmp_variant: Schema.Attribute.String & Schema.Attribute.Required;
    description: Schema.Attribute.String;
    items: Schema.Attribute.Component<'items.testimonial-item', true>;
    subtitle: Schema.Attribute.String;
    title: Schema.Attribute.String;
  };
}

export interface GlobalFooter extends Struct.ComponentSchema {
  collectionName: 'components_global_footers';
  info: {
    description: '';
    displayName: 'Footer';
    icon: 'apps';
  };
  attributes: {
    buttons: Schema.Attribute.Component<'shared.button', true>;
    cmp_variant: Schema.Attribute.String & Schema.Attribute.Required;
    copyright: Schema.Attribute.String;
    darkLogo: Schema.Attribute.Media<'images'>;
    lightLogo: Schema.Attribute.Media<'images'>;
    subtitle: Schema.Attribute.String;
    tagline: Schema.Attribute.String;
    title: Schema.Attribute.String;
  };
}

export interface GlobalHeader extends Struct.ComponentSchema {
  collectionName: 'components_global_navbars';
  info: {
    description: '';
    displayName: 'Navbar';
    icon: 'bold';
  };
  attributes: {
    buttons: Schema.Attribute.Component<'shared.button', true>;
    cmp_variant: Schema.Attribute.String & Schema.Attribute.Required;
    darkLogo: Schema.Attribute.Media<'images'>;
    lightLogo: Schema.Attribute.Media<'images'>;
    subtitle: Schema.Attribute.String;
    tagline: Schema.Attribute.String;
    title: Schema.Attribute.String;
  };
}

export interface GlobalNotFound extends Struct.ComponentSchema {
  collectionName: 'components_global_not_founds';
  info: {
    description: '';
    displayName: 'Not Found';
    icon: 'bold';
  };
  attributes: {
    buttons: Schema.Attribute.Component<'shared.button', true>;
    cmp_variant: Schema.Attribute.String & Schema.Attribute.Required;
    description: Schema.Attribute.Text;
    image: Schema.Attribute.Media<'images'>;
    subtitle: Schema.Attribute.Text;
    title: Schema.Attribute.String;
  };
}

export interface ItemsCardItem extends Struct.ComponentSchema {
  collectionName: 'components_items_card7_item';
  info: {
    displayName: 'Card7 Item';
    icon: 'card';
  };
  attributes: {
    date: Schema.Attribute.Date & Schema.Attribute.Required;
    image: Schema.Attribute.Media<'images'> & Schema.Attribute.Required;
    isFeatured: Schema.Attribute.Boolean;
    slug: Schema.Attribute.UID &
      Schema.Attribute.Required &
      Schema.Attribute.SetPluginOptions<{
        i18n: {
          localized: true;
        };
      }>;
    title: Schema.Attribute.String & Schema.Attribute.Required;
  };
}

export interface ItemsFaqItem extends Struct.ComponentSchema {
  collectionName: 'components_items_faq_items';
  info: {
    displayName: 'Faq_Item';
  };
  attributes: {
    answer: Schema.Attribute.Text;
    isOpen: Schema.Attribute.Boolean;
    question: Schema.Attribute.String;
  };
}

export interface ItemsTestimonialItem extends Struct.ComponentSchema {
  collectionName: 'components_shared_testimonial_items';
  info: {
    displayName: 'TestimonialItems';
    icon: 'gift';
  };
  attributes: {
    company: Schema.Attribute.String;
    date: Schema.Attribute.Date;
    designation: Schema.Attribute.String;
    image: Schema.Attribute.Media<'images'>;
    location: Schema.Attribute.String;
    message: Schema.Attribute.Text & Schema.Attribute.Required;
    name: Schema.Attribute.String;
    rating: Schema.Attribute.Float;
  };
}

export interface SharedButton extends Struct.ComponentSchema {
  collectionName: 'components_shared_buttons';
  info: {
    description: '';
    displayName: 'Button';
    icon: 'cursor';
  };
  attributes: {
    icon: Schema.Attribute.Media<'images'>;
    label: Schema.Attribute.String;
    path: Schema.Attribute.String;
    size: Schema.Attribute.Enumeration<['default', 'sm', 'lg', 'icon']> &
      Schema.Attribute.DefaultTo<'default'>;
    target: Schema.Attribute.Enumeration<
      ['_self', '_blank', '_parent', '_top']
    > &
      Schema.Attribute.DefaultTo<'_self'>;
    variant: Schema.Attribute.Enumeration<
      ['default', 'secondary', 'outline', 'ghost', 'link', 'destructive']
    > &
      Schema.Attribute.DefaultTo<'default'>;
  };
}

export interface SharedLogo extends Struct.ComponentSchema {
  collectionName: 'components_shared_logos';
  info: {
    displayName: 'logo';
  };
  attributes: {
    darkLogo: Schema.Attribute.Media<'images'>;
    lightLogo: Schema.Attribute.Media<'images'>;
    type: Schema.Attribute.Enumeration<['primary', 'secondary', 'tertiary']> &
      Schema.Attribute.DefaultTo<'primary'>;
  };
}

export interface SharedMedia extends Struct.ComponentSchema {
  collectionName: 'components_shared_media';
  info: {
    displayName: 'Media';
    icon: 'file-video';
  };
  attributes: {
    file: Schema.Attribute.Media<'images' | 'files' | 'videos'>;
  };
}

export interface SharedQuote extends Struct.ComponentSchema {
  collectionName: 'components_shared_quotes';
  info: {
    displayName: 'Quote';
    icon: 'indent';
  };
  attributes: {
    body: Schema.Attribute.Text;
    title: Schema.Attribute.String;
  };
}

export interface SharedRichText extends Struct.ComponentSchema {
  collectionName: 'components_shared_rich_texts';
  info: {
    description: '';
    displayName: 'Rich text';
    icon: 'align-justify';
  };
  attributes: {
    body: Schema.Attribute.RichText;
  };
}

export interface SharedSecondaryLogo extends Struct.ComponentSchema {
  collectionName: 'components_shared_secondary_logos';
  info: {
    displayName: 'Secondary Logo';
  };
  attributes: {
    darkLogo: Schema.Attribute.Media<'images'>;
    lightLogo: Schema.Attribute.Media<'images'>;
    subtitle: Schema.Attribute.String;
    tagline: Schema.Attribute.String;
    title: Schema.Attribute.String;
  };
}

export interface SharedSeo extends Struct.ComponentSchema {
  collectionName: 'components_shared_seos';
  info: {
    description: '';
    displayName: 'seo';
    icon: 'search';
  };
  attributes: {
    canonicalURL: Schema.Attribute.String;
    keywords: Schema.Attribute.Text;
    metaDescription: Schema.Attribute.Text;
    metaImage: Schema.Attribute.Media<'images' | 'files' | 'videos'>;
    metaRobots: Schema.Attribute.String;
    metaTitle: Schema.Attribute.String;
    metaViewport: Schema.Attribute.String;
    structuredData: Schema.Attribute.JSON;
  };
}

export interface SharedSlider extends Struct.ComponentSchema {
  collectionName: 'components_shared_sliders';
  info: {
    description: '';
    displayName: 'Slider';
    icon: 'address-book';
  };
  attributes: {
    files: Schema.Attribute.Media<'images', true>;
  };
}

export interface SharedSocialLink extends Struct.ComponentSchema {
  collectionName: 'components_shared_social_links';
  info: {
    description: 'Flexible social media or external link';
    displayName: 'Social Link';
    icon: 'link';
  };
  attributes: {
    icon: Schema.Attribute.Media<'images'>;
    label: Schema.Attribute.String;
    type: Schema.Attribute.Enumeration<['primary', 'secondary', 'tertiary']> &
      Schema.Attribute.DefaultTo<'primary'>;
    url: Schema.Attribute.String & Schema.Attribute.Required;
  };
}

declare module '@strapi/strapi' {
  export module Public {
    export interface ComponentSchemas {
      'dynamic-zone.about': DynamicZoneAbout;
      'dynamic-zone.card': DynamicZoneCard;
      'dynamic-zone.cta': DynamicZoneCta;
      'dynamic-zone.faq': DynamicZoneFaq;
      'dynamic-zone.hero': DynamicZoneHero;
      'dynamic-zone.testimonial': DynamicZoneTestimonial;
      'global.footer': GlobalFooter;
      'global.header': GlobalHeader;
      'global.not-found': GlobalNotFound;
      'items.card-item': ItemsCardItem;
      'items.faq-item': ItemsFaqItem;
      'items.testimonial-item': ItemsTestimonialItem;
      'shared.button': SharedButton;
      'shared.logo': SharedLogo;
      'shared.media': SharedMedia;
      'shared.quote': SharedQuote;
      'shared.rich-text': SharedRichText;
      'shared.secondary-logo': SharedSecondaryLogo;
      'shared.seo': SharedSeo;
      'shared.slider': SharedSlider;
      'shared.social-link': SharedSocialLink;
    }
  }
}
